/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellItem;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWToolTipTableCellRenderer
extends DefaultTableCellRenderer {
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        if (component != null && component instanceof JLabel) {
            component.setComponentOrientation(table.getComponentOrientation());
            JLabel label = (JLabel)component;
            label.setIcon(null);
            label.setText("");
            label.setToolTipText(null);
            if (value != null) {
                if (value instanceof String) {
                    String string = value.toString();
                    string = string.replace('\n', ' ');
                    label.setText(string);
                    label.setToolTipText(VWStringUtils.formatToolTip(string, 0));
                } else if (value instanceof VWToolTipTableCellItem) {
                    ImageIcon icon;
                    VWToolTipTableCellItem item = (VWToolTipTableCellItem)value;
                    String text = item.getText();
                    if (text != null && text.length() > 0) {
                        label.setToolTipText(VWStringUtils.formatToolTip(text, 0));
                    }
                    if ((icon = item.getIcon()) != null) {
                        label.setIcon(icon);
                    }
                }
            }
        }
        return component;
    }
}

